/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.network;

import com.mojang.logging.LogUtils;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_310;

public class InteractionManager {
    public static final Waiter TICK_WAITER = triggerType -> triggerType == TriggerType.TICK;
    private static final Queue<InteractionEvent> interactionEventQueue = new ArrayDeque<InteractionEvent>();
    private static final ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(1);
    private static ScheduledFuture<?> tickFuture;
    private static Waiter waiter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void push(InteractionEvent interactionEvent) {
        if (interactionEvent == null) {
            return;
        }
        Queue<InteractionEvent> queue = interactionEventQueue;
        synchronized (queue) {
            interactionEventQueue.add(interactionEvent);
            if (waiter == null) {
                InteractionManager.triggerSend(TriggerType.INITIAL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushAll(Collection<InteractionEvent> interactionEvents) {
        if (interactionEvents == null) {
            return;
        }
        Queue<InteractionEvent> queue = interactionEventQueue;
        synchronized (queue) {
            interactionEventQueue.addAll(interactionEvents);
            if (waiter == null) {
                InteractionManager.triggerSend(TriggerType.INITIAL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Queue<InteractionEvent> queue = interactionEventQueue;
        synchronized (queue) {
            interactionEventQueue.clear();
            waiter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void triggerSend(TriggerType triggerType) {
        Queue<InteractionEvent> queue = interactionEventQueue;
        synchronized (queue) {
            if (waiter == null || waiter.trigger(triggerType)) {
                do {
                    InteractionEvent event;
                    if ((event = interactionEventQueue.poll()) == null) {
                        waiter = null;
                        break;
                    }
                    InteractionManager.doSendEvent(event);
                } while (waiter.trigger(TriggerType.INITIAL));
            }
        }
    }

    private static void doSendEvent(InteractionEvent event) {
        Waiter blockingWaiter;
        waiter = blockingWaiter = tt -> false;
        class_310.method_1551().execute(() -> {
            Queue<InteractionEvent> queue = interactionEventQueue;
            synchronized (queue) {
                if (waiter == blockingWaiter) {
                    waiter = event.send();
                }
            }
        });
    }

    public static void setTickRate(long milliSeconds) {
        if (tickFuture != null) {
            tickFuture.cancel(false);
        }
        tickFuture = scheduledExecutor.scheduleAtFixedRate(InteractionManager::tick, milliSeconds, milliSeconds, TimeUnit.MILLISECONDS);
    }

    private static void tick() {
        try {
            InteractionManager.triggerSend(TriggerType.TICK);
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Error while ticking InteractionManager", (Throwable)e);
        }
    }

    static {
        waiter = null;
    }

    @FunctionalInterface
    public static interface Waiter {
        public boolean trigger(TriggerType var1);

        public static Waiter equal(TriggerType triggerType) {
            return triggerType::equals;
        }
    }

    public static enum TriggerType {
        INITIAL,
        CONTAINER_SLOT_UPDATE,
        GUI_CONFIRM,
        HELD_ITEM_CHANGE,
        TICK;

    }

    @FunctionalInterface
    public static interface InteractionEvent {
        public Waiter send();
    }

    public static class CallbackEvent
    implements InteractionEvent {
        private final Supplier<Waiter> callback;

        public CallbackEvent(Supplier<Waiter> callback) {
            this.callback = callback;
        }

        @Override
        public Waiter send() {
            return this.callback.get();
        }
    }

    @FunctionalInterface
    public static interface ClickEventFactory {
        public InteractionEvent create(class_1735 var1, int var2, class_1713 var3, boolean var4);
    }

    @Deprecated
    public static class GuiConfirmWaiter
    implements Waiter {
        int triggers;

        public GuiConfirmWaiter(int triggers) {
            this.triggers = triggers;
        }

        @Override
        public boolean trigger(TriggerType triggerType) {
            return triggerType == TriggerType.GUI_CONFIRM && --this.triggers == 0;
        }
    }
}

